<?php

function redirect_to($rdr_link) {
    if (!empty($rdr_link)) {
        header("Location: /".$rdr_link);
        die();
    }
}

/**
* Secure Text
*/

function txt($text) {
    /* decode txt */
    $text = txt_secure($text);
    /* ispravi txt */
    $text = zt_text($text);
    /* decode urls */
    $text = url_secure($text);
    /* decode links */
    $text = decode_urls($text);

    return $text;
}

function zt_text($zt_txt) {
    $s_zamene = array (
        '&lt;3'     => ':_3',
        '&lt;/3'    => ':_/3',
        'picka'     => '**cka',
        'kurac'     => '**rac',
        'svinja'    => '**inja',
        'stoka'     => '**oka',
        'materina'  => '***erina',
    );
        
    $zt_txt = str_replace(array_keys($s_zamene), array_values($s_zamene), $zt_txt);
    
    return $zt_txt;
}

/**
* Valid email
*/

function valid_email($email) {
    if(filter_var($email, FILTER_VALIDATE_EMAIL) !== false) {
        return true;
    } else {
        return false;
    }
}

/**
* Secure Text
*/

function txt_secure($string, $br = true) {
	if ($string === null) {
		$string = '';
	}
	$string = trim($string);
  //  $string = mysql_real_escape_string($string);
    $string = htmlspecialchars($string, ENT_QUOTES);

    if ($br == true) {
        $string = str_replace('\r\n', " <br />", $string);
        $string = str_replace('\n\r', " <br />", $string);
        $string = str_replace('\r', " <br />", $string);
        $string = str_replace('\n', " <br />", $string);
    } else {
        $string = str_replace('\r\n', "", $string);
        $string = str_replace('\n\r', "", $string);
        $string = str_replace('\r', "", $string);
        $string = str_replace('\n', "", $string);
    }

    $string = stripslashes($string);
    $string = str_replace('&amp;#', '&#', $string);

    return $string;
}

function txt_secure2($string, $br = true) {
	if ($string === null) {
		$string = '';
	}
	$string = trim($string);
    //$string = mysql_real_escape_string($string);
    $string = htmlspecialchars($string, ENT_QUOTES);
    if ($br == true) {
        $string = str_replace('\r\n', " <br>", $string);
        $string = str_replace('\n\r', " <br>", $string);
        $string = str_replace('\r', " <br>", $string);
        $string = str_replace('\n', " <br>", $string);
    } else {
        $string = str_replace('\r\n', "", $string);
        $string = str_replace('\n\r', "", $string);
        $string = str_replace('\r', "", $string);
        $string = str_replace('\n', "", $string);
    }
    $string = stripslashes($string);
    $string = str_replace('&amp;#', '&#', $string);

    return $string;
}

/**
* Detect smile in text
*/

function smile($smile) {
    /*$smile = str_replace('&lt;3', "<i class='fa fa-heart'></i>", $smile);
    $smile = str_replace('&lt;/3', "<i class='fa fa-heart'></i>", $smile);

    $smile = str_replace(':D', "<i class='icomoon icon-smiley'></i>", $smile);
    $smile = str_replace(':)', "<i class='icomoon icon-smiley'></i>", $smile);
    $smile = str_replace(':(', "<i class='fa fa-frown-o'></i>", $smile);
    $smile = str_replace(':|', "<i class='icomoon icon-neutral'></i>", $smile);
    
    $smile = str_replace(';)', "<i class='icomoon icon-wink'></i>", $smile);
    $smile = str_replace(':P', "<i class='icomoon icon-tongue'></i>", $smile);
    $smile = str_replace(':O', "<i class='icomoon icon-shocked'></i>", $smile);
    $smile = str_replace(':~', "<i class='icomoon icon-cool'></i>", $smile);*/

    $s_zamene = array (
        ':D'        => '<img src="/assets/img/icon/smile/002.png"  class="smile-img-icon">',
        ':P'        => '<img src="/assets/img/icon/smile/104.png"  class="smile-img-icon">',
        'o.o'       => '<img src="/assets/img/icon/smile/012.png"  class="smile-img-icon">',
        ':)'        => '<img src="/assets/img/icon/smile/001.png"  class="smile-img-icon">',
        ':m'        => '<img src="/assets/img/icon/smile/006.png"  class="smile-img-icon">',
        ';)'        => '<img src="/assets/img/icon/smile/003.gif"  class="smile-img-icon">',
        ':O'        => '<img src="/assets/img/icon/smile/004.png"  class="smile-img-icon">',
        ':/'        => '<img src="/assets/img/icon/smile/007.png"  class="smile-img-icon">',
        ':$'        => '<img src="/assets/img/icon/smile/008.png"  class="smile-img-icon">',
        ':S'        => '<img src="/assets/img/icon/smile/009.png"  class="smile-img-icon">',
        ':('        => '<img src="/assets/img/icon/smile/010.png"  class="smile-img-icon">',
        ';('        => '<img src="/assets/img/icon/smile/011.gif"  class="smile-img-icon">',
        ':_3'       => '<img src="/assets/img/icon/smile/015.png"  class="smile-img-icon">',
        ':_/3'      => '<img src="/assets/img/icon/smile/016.png"  class="smile-img-icon">',
        '-.-'       => '<img src="/assets/img/icon/smile/083.png"  class="smile-img-icon">',
        ':n'        => '<img src="/assets/img/icon/smile/086.png"  class="smile-img-icon">',
        ':P'        => '<img src="/assets/img/icon/smile/104.png"  class="smile-img-icon">',
        ':T'        => '<img src="/assets/img/icon/smile/tuga.gif" class="smile-img-icon">',
        'xD'        => '<img src="/assets/img/icon/smile/xD.png"   class="smile-img-icon">',
        '.!.'       => '<img src="/assets/img/icon/smile/kk.png"   class="smile-img-icon">',
        'picka'     => '**cka',
        'kurac'     => '**rac',
        'svinja'    => '**inja',
        'stoka'     => '**oka',
        'materina'  => '***erina',
    );
        
    $smile = str_replace(array_keys($s_zamene), array_values($s_zamene), $smile);
    
    return $smile;
}

/**
* Detect url in text
*/

function decode_urls($text) {
    $text = preg_replace('/(https?:\/\/[^\s]+)/', "<a target='_blank' href='$1'>$1</a>", $text);
    return $text;
}

/**
* HTTPS secure page
*/

function https_secure() {
    return (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || $_SERVER['SERVER_PORT'] == 443;
}

/**
* Replace text
*/

function url_secure($url_secure) {
    // Latin
    $url_secure = str_replace('', 'A', $url_secure);
    $url_secure = str_replace('', 'A', $url_secure);
    $url_secure = str_replace('', 'A', $url_secure);
    $url_secure = str_replace('', 'A', $url_secure);
    $url_secure = str_replace('', 'A', $url_secure);
    $url_secure = str_replace('', 'A', $url_secure);
    $url_secure = str_replace('', 'AE', $url_secure);
    $url_secure = str_replace('', 'C', $url_secure);
    $url_secure = str_replace('', 'E', $url_secure);
    $url_secure = str_replace('', 'E', $url_secure);
    $url_secure = str_replace('', 'E', $url_secure);
    $url_secure = str_replace('', 'E', $url_secure);
    $url_secure = str_replace('', 'I', $url_secure);
    $url_secure = str_replace('', 'I', $url_secure);
    $url_secure = str_replace('', 'I', $url_secure);
    $url_secure = str_replace('', 'I', $url_secure);
    $url_secure = str_replace('', 'D', $url_secure);
    $url_secure = str_replace('', 'N', $url_secure);
    $url_secure = str_replace('', 'O', $url_secure);
    $url_secure = str_replace('', 'O', $url_secure);
    $url_secure = str_replace('', 'O', $url_secure);
    $url_secure = str_replace('', 'O', $url_secure);
    $url_secure = str_replace('', 'O', $url_secure);
    $url_secure = str_replace('O', 'O', $url_secure);
    $url_secure = str_replace('', 'O', $url_secure);
    $url_secure = str_replace('', 'U', $url_secure);
    $url_secure = str_replace('', 'U', $url_secure);
    $url_secure = str_replace('', 'U', $url_secure);
    $url_secure = str_replace('', 'U', $url_secure);
    $url_secure = str_replace('U', 'U', $url_secure);
    $url_secure = str_replace('', 'Y', $url_secure);
    $url_secure = str_replace('', 'TH', $url_secure);
    $url_secure = str_replace('', 'ss', $url_secure);
    $url_secure = str_replace('', 'a', $url_secure);
    $url_secure = str_replace('', 'a', $url_secure);
    $url_secure = str_replace('', 'a', $url_secure);
    $url_secure = str_replace('', 'a', $url_secure);
    $url_secure = str_replace('', 'a', $url_secure);
    $url_secure = str_replace('', 'a', $url_secure);
    $url_secure = str_replace('', 'ae', $url_secure);
    $url_secure = str_replace('', 'c', $url_secure);
    $url_secure = str_replace('', 'e', $url_secure);
    $url_secure = str_replace('', 'e', $url_secure);
    $url_secure = str_replace('', 'e', $url_secure);
    $url_secure = str_replace('', 'e', $url_secure);
    $url_secure = str_replace('', 'i', $url_secure);
    $url_secure = str_replace('', 'i', $url_secure);
    $url_secure = str_replace('', 'i', $url_secure);
    $url_secure = str_replace('', 'i', $url_secure);
    $url_secure = str_replace('', 'd', $url_secure);
    $url_secure = str_replace('', 'n', $url_secure);
    $url_secure = str_replace('', 'o', $url_secure);
    $url_secure = str_replace('', 'o', $url_secure);
    $url_secure = str_replace('', 'o', $url_secure);
    $url_secure = str_replace('', 'o', $url_secure);
    $url_secure = str_replace('', 'o', $url_secure);
    $url_secure = str_replace('o', 'o', $url_secure);
    $url_secure = str_replace('', 'o', $url_secure);
    $url_secure = str_replace('', 'u', $url_secure);
    $url_secure = str_replace('', 'u', $url_secure);
    $url_secure = str_replace('', 'u', $url_secure);
    $url_secure = str_replace('', 'u', $url_secure);
    $url_secure = str_replace('u', 'u', $url_secure);
    $url_secure = str_replace('', 'y', $url_secure);
    $url_secure = str_replace('', 'th', $url_secure);
    $url_secure = str_replace('', 'y', $url_secure);
    
    // Symbols
    $url_secure = str_replace('&copy;', '(c)', $url_secure);
    $url_secure = str_replace('', '(c)', $url_secure);
    
    // Greek
    $url_secure = str_replace('?', 'A', $url_secure);
    $url_secure = str_replace('?', 'B', $url_secure);
    $url_secure = str_replace('G', 'G', $url_secure);
    $url_secure = str_replace('?', 'D', $url_secure);
    $url_secure = str_replace('?', 'E', $url_secure);
    $url_secure = str_replace('?', 'Z', $url_secure);
    $url_secure = str_replace('?', 'H', $url_secure);
    $url_secure = str_replace('T', '8', $url_secure);
    $url_secure = str_replace('?', 'I', $url_secure);
    $url_secure = str_replace('?', 'K', $url_secure);
    $url_secure = str_replace('?', 'L', $url_secure);
    $url_secure = str_replace('?', 'M', $url_secure);
    $url_secure = str_replace('?', 'N', $url_secure);
    $url_secure = str_replace('?', '3', $url_secure);
    $url_secure = str_replace('?', 'O', $url_secure);
    $url_secure = str_replace('?', 'P', $url_secure);
    $url_secure = str_replace('?', 'R', $url_secure);
    $url_secure = str_replace('S', 'S', $url_secure);
    $url_secure = str_replace('?', 'T', $url_secure);
    $url_secure = str_replace('?', 'Y', $url_secure);
    $url_secure = str_replace('F', 'F', $url_secure);
    $url_secure = str_replace('?', 'X', $url_secure);
    $url_secure = str_replace('?', 'PS', $url_secure);
    $url_secure = str_replace('O', 'W', $url_secure);
    $url_secure = str_replace('?', 'A', $url_secure);
    $url_secure = str_replace('?', 'E', $url_secure);
    $url_secure = str_replace('?', 'I', $url_secure);
    $url_secure = str_replace('?', 'O', $url_secure);
    $url_secure = str_replace('?', 'Y', $url_secure);
    $url_secure = str_replace('?', 'H', $url_secure);
    $url_secure = str_replace('?', 'W', $url_secure);
    $url_secure = str_replace('?', 'I', $url_secure);
    $url_secure = str_replace('?', 'Y', $url_secure);
    $url_secure = str_replace('a', 'a', $url_secure);
    $url_secure = str_replace('', 'b', $url_secure);
    $url_secure = str_replace('?', 'g', $url_secure);
    $url_secure = str_replace('d', 'd', $url_secure);
    $url_secure = str_replace('e', 'e', $url_secure);
    $url_secure = str_replace('?', 'z', $url_secure);
    $url_secure = str_replace('?', 'h', $url_secure);
    $url_secure = str_replace('?', '8', $url_secure);
    $url_secure = str_replace('?', 'i', $url_secure);
    $url_secure = str_replace('?', 'k', $url_secure);
    $url_secure = str_replace('?', 'l', $url_secure);
    $url_secure = str_replace('', 'm', $url_secure);
    $url_secure = str_replace('?', 'n', $url_secure);
    $url_secure = str_replace('?', '3', $url_secure);
    $url_secure = str_replace('?', 'o', $url_secure);
    $url_secure = str_replace('p', 'p', $url_secure);
    $url_secure = str_replace('?', 'r', $url_secure);
    $url_secure = str_replace('s', 's', $url_secure);
    $url_secure = str_replace('t', 't', $url_secure);
    $url_secure = str_replace('?', 'y', $url_secure);
    $url_secure = str_replace('f', 'f', $url_secure);
    $url_secure = str_replace('?', 'x', $url_secure);
    $url_secure = str_replace('?', 'ps', $url_secure);
    $url_secure = str_replace('?', 'w', $url_secure);
    $url_secure = str_replace('?', 'a', $url_secure);
    $url_secure = str_replace('?', 'e', $url_secure);
    $url_secure = str_replace('?', 'i', $url_secure);
    $url_secure = str_replace('?', 'o', $url_secure);
    $url_secure = str_replace('?', 'y', $url_secure);
    $url_secure = str_replace('?', 'h', $url_secure);
    $url_secure = str_replace('?', 'w', $url_secure);
    $url_secure = str_replace('?', 's', $url_secure);
    $url_secure = str_replace('?', 'i', $url_secure);
    $url_secure = str_replace('?', 'y', $url_secure);
    $url_secure = str_replace('?', 'y', $url_secure);
    $url_secure = str_replace('?', 'i', $url_secure);
    
    // Turkish
    $url_secure = str_replace('S', 'S', $url_secure);
    $url_secure = str_replace('I', 'I', $url_secure);
    $url_secure = str_replace('', 'C', $url_secure);
    $url_secure = str_replace('', 'U', $url_secure);
    $url_secure = str_replace('', 'O', $url_secure);
    $url_secure = str_replace('G', 'G', $url_secure);
    $url_secure = str_replace('s', 's', $url_secure);
    $url_secure = str_replace('i', 'i', $url_secure);
    $url_secure = str_replace('', 'c', $url_secure);
    $url_secure = str_replace('', 'u', $url_secure);
    $url_secure = str_replace('', 'o', $url_secure);
    $url_secure = str_replace('g', 'g', $url_secure);
    
    // Russian
    $url_secure = str_replace('?', 'A', $url_secure);
    $url_secure = str_replace('?', 'B', $url_secure);
    $url_secure = str_replace('?', 'V', $url_secure);
    $url_secure = str_replace('?', 'G', $url_secure);
    $url_secure = str_replace('?', 'D', $url_secure);
    $url_secure = str_replace('?', 'E', $url_secure);
    $url_secure = str_replace('?', 'Yo', $url_secure);
    $url_secure = str_replace('?', 'Zh', $url_secure);
    $url_secure = str_replace('?', 'Z', $url_secure);
    $url_secure = str_replace('?', 'I', $url_secure);
    $url_secure = str_replace('?', 'J', $url_secure);
    $url_secure = str_replace('?', 'K', $url_secure);
    $url_secure = str_replace('?', 'L', $url_secure);
    $url_secure = str_replace('?', 'M', $url_secure);
    $url_secure = str_replace('?', 'N', $url_secure);
    $url_secure = str_replace('?', 'O', $url_secure);
    $url_secure = str_replace('?', 'P', $url_secure);
    $url_secure = str_replace('?', 'R', $url_secure);
    $url_secure = str_replace('?', 'S', $url_secure);
    $url_secure = str_replace('?', 'T', $url_secure);
    $url_secure = str_replace('?', 'U', $url_secure);
    $url_secure = str_replace('?', 'F', $url_secure);
    $url_secure = str_replace('?', 'H', $url_secure);
    $url_secure = str_replace('?', 'C', $url_secure);
    $url_secure = str_replace('?', 'Ch', $url_secure);
    $url_secure = str_replace('?', 'Sh', $url_secure);
    $url_secure = str_replace('?', 'Sh', $url_secure);
    $url_secure = str_replace('?', '', $url_secure);
    $url_secure = str_replace('?', 'Y', $url_secure);
    $url_secure = str_replace('?', '', $url_secure);
    $url_secure = str_replace('?', 'E', $url_secure);
    $url_secure = str_replace('?', 'Yu', $url_secure);
    $url_secure = str_replace('?', 'Ya', $url_secure);
    $url_secure = str_replace('?', 'a', $url_secure);
    $url_secure = str_replace('?', 'b', $url_secure);
    $url_secure = str_replace('?', 'v', $url_secure);
    $url_secure = str_replace('?', 'g', $url_secure);
    $url_secure = str_replace('?', 'd', $url_secure);
    $url_secure = str_replace('?', 'e', $url_secure);
    $url_secure = str_replace('?', 'yo', $url_secure);
    $url_secure = str_replace('?', 'zh', $url_secure);
    $url_secure = str_replace('?', 'z', $url_secure);
    $url_secure = str_replace('?', 'i', $url_secure);
    $url_secure = str_replace('?', 'j', $url_secure);
    $url_secure = str_replace('?', 'k', $url_secure);
    $url_secure = str_replace('?', 'l', $url_secure);
    $url_secure = str_replace('?', 'm', $url_secure);
    $url_secure = str_replace('?', 'n', $url_secure);
    $url_secure = str_replace('?', 'o', $url_secure);
    $url_secure = str_replace('?', 'p', $url_secure);
    $url_secure = str_replace('?', 'r', $url_secure);
    $url_secure = str_replace('?', 's', $url_secure);
    $url_secure = str_replace('?', 't', $url_secure);
    $url_secure = str_replace('?', 'u', $url_secure);
    $url_secure = str_replace('?', 'f', $url_secure);
    $url_secure = str_replace('?', 'h', $url_secure);
    $url_secure = str_replace('?', 'c', $url_secure);
    $url_secure = str_replace('?', 'ch', $url_secure);
    $url_secure = str_replace('?', 'sh', $url_secure);
    $url_secure = str_replace('?', 'sh', $url_secure);
    $url_secure = str_replace('?', '', $url_secure);
    $url_secure = str_replace('?', 'y', $url_secure);
    $url_secure = str_replace('?', '', $url_secure);
    $url_secure = str_replace('?', 'e', $url_secure);
    $url_secure = str_replace('?', 'yu', $url_secure);
    $url_secure = str_replace('?', 'ya', $url_secure);
    
    // Ukrainian
    $url_secure = str_replace('?', 'Ye', $url_secure);
    $url_secure = str_replace('?', 'I', $url_secure);
    $url_secure = str_replace('?', 'Yi', $url_secure);
    $url_secure = str_replace('?', 'G', $url_secure);
    $url_secure = str_replace('?', 'ye', $url_secure);
    $url_secure = str_replace('?', 'i', $url_secure);
    $url_secure = str_replace('?', 'yi', $url_secure);
    $url_secure = str_replace('?', 'g', $url_secure);
    
    // Czech
    $url_secure = str_replace('C', 'C', $url_secure);
    $url_secure = str_replace('D', 'D', $url_secure);
    $url_secure = str_replace('E', 'E', $url_secure);
    $url_secure = str_replace('N', 'N', $url_secure);
    $url_secure = str_replace('R', 'R', $url_secure);
    $url_secure = str_replace('', 'S', $url_secure);
    $url_secure = str_replace('T', 'T', $url_secure);
    $url_secure = str_replace('U', 'U', $url_secure);
    $url_secure = str_replace('', 'Z', $url_secure);
    $url_secure = str_replace('c', 'c', $url_secure);
    $url_secure = str_replace('d', 'd', $url_secure);
    $url_secure = str_replace('e', 'e', $url_secure);
    $url_secure = str_replace('n', 'n', $url_secure);
    $url_secure = str_replace('r', 'r', $url_secure);
    $url_secure = str_replace('', 's', $url_secure);
    $url_secure = str_replace('t', 't', $url_secure);
    $url_secure = str_replace('u', 'u', $url_secure);
    $url_secure = str_replace('', 'z', $url_secure);
    
    // Polish
    $url_secure = str_replace('A', 'A', $url_secure);
    $url_secure = str_replace('C', 'C', $url_secure);
    $url_secure = str_replace('E', 'e', $url_secure);
    $url_secure = str_replace('L', 'L', $url_secure);
    $url_secure = str_replace('N', 'N', $url_secure);
    $url_secure = str_replace('', 'o', $url_secure);
    $url_secure = str_replace('S', 'S', $url_secure);
    $url_secure = str_replace('Z', 'Z', $url_secure);
    $url_secure = str_replace('Z', 'Z', $url_secure);
    $url_secure = str_replace('a', 'a', $url_secure);
    $url_secure = str_replace('c', 'c', $url_secure);
    $url_secure = str_replace('e', 'e', $url_secure);
    $url_secure = str_replace('l', 'l', $url_secure);
    $url_secure = str_replace('n', 'n', $url_secure);
    $url_secure = str_replace('', 'o', $url_secure);
    $url_secure = str_replace('s', 's', $url_secure);
    $url_secure = str_replace('z', 'z', $url_secure);
    $url_secure = str_replace('z', 'z', $url_secure);
    
    // Latvian
    $url_secure = str_replace('A', 'A', $url_secure);
    $url_secure = str_replace('C', 'C', $url_secure);
    $url_secure = str_replace('E', 'E', $url_secure);
    $url_secure = str_replace('G', 'G', $url_secure);
    $url_secure = str_replace('I', 'i', $url_secure);
    $url_secure = str_replace('K', 'k', $url_secure);
    $url_secure = str_replace('L', 'L', $url_secure);
    $url_secure = str_replace('N', 'N', $url_secure);
    $url_secure = str_replace('', 'S', $url_secure);
    $url_secure = str_replace('U', 'u', $url_secure);
    $url_secure = str_replace('', 'Z', $url_secure);
    $url_secure = str_replace('a', 'a', $url_secure);
    $url_secure = str_replace('c', 'c', $url_secure);
    $url_secure = str_replace('e', 'e', $url_secure);
    $url_secure = str_replace('g', 'g', $url_secure);
    $url_secure = str_replace('i', 'i', $url_secure);
    $url_secure = str_replace('k', 'k', $url_secure);
    $url_secure = str_replace('l', 'l', $url_secure);
    $url_secure = str_replace('n', 'n', $url_secure);
    $url_secure = str_replace('', 's', $url_secure);
    $url_secure = str_replace('u', 'u', $url_secure);
    $url_secure = str_replace('', 'z', $url_secure);

    return $url_secure;
}

function obgpfw() {
@header("X-XSS-Protection: 1");
@header("X-Content-Type-Options: nosniff");
$_GET  = filter_input_array(INPUT_GET, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_HIGH);
$_POST = filter_input_array(INPUT_POST, FILTER_SANITIZE_STRING, FILTER_FLAG_STRIP_HIGH);
        if (!function_exists('cleanInput')) {
            function cleanInput($input)
            {
                $search = array(
                    '@<script[^>]*?>.*?</script>@si', // Strip out javascript
                    '@<[\/\!]*?[^<>]*?>@si', // Strip out HTML tags
                    '@<style[^>]*?>.*?</style>@siU', // Strip style tags properly
                    '@<![\s\S]*?--[ \t\n\r]*>@' // Strip multi-line comments
                );
                
                $output = preg_replace($search, '', $input);
                return $output;
            }
        }
        
        if (!function_exists('sanitize')) {
            function sanitize($input)
            {
                if (is_array($input)) {
                    foreach ($input as $var => $val) {
                        $output[$var] = sanitize($val);
                    }
                } else {
                    $input  = str_replace('"', "", $input);
                    $input  = str_replace("'", "", $input);
                    $input  = cleanInput($input);
                    $output = htmlentities($input, ENT_QUOTES);
                }
                return @$output;
            }
        }
        $_POST    = sanitize($_POST);
        $_GET     = sanitize($_GET);
        $_REQUEST = sanitize($_REQUEST);
        $_COOKIE  = sanitize($_COOKIE);
        if (isset($_SESSION)) {
            $_SESSION = sanitize($_SESSION);
        }
        $query_string = $_SERVER['QUERY_STRING'];
        $patterns = array(
        "+select+",
        "+union+",
        "union+",
        "+or+",
        "**/",
        "/**",
        "0x3a",
        "/*",
        "*/",
        "*",
        "--",
        ";",
        "||",
        "' #",
        "or 1=1",
        "'1'='1",
        "S@BUN",
        "`",
        "'",
        '"',
        "[",
        "]",
        "<",
        ">",
        "++",
        "1,1",
        "1=1",
        "sleep(",
        "%27",
        "%22",
        "(",
        ")",
        "<?",
        "<?php",
        "?>",
        "../",
        "/localhost",
        "127.0.0.1",
        "loopback",
        "%0A",
        "%0D",
        "%3C",
        "%3E",
        "%00",
        "%2e%2e",
        "input_file",
        "path=.",
        "mod=.",
        "eval\(",
        "javascript:",
        "base64_",
        "boot.ini",
        "etc/passwd",
        "self/environ",
        "echo.*kae",
        "=%27$"
    );
     foreach ($patterns as $pattern) {
     if (strpos(strtolower($query_string), strtolower($pattern)) !== false) {
            echo '<meta http-equiv="refresh" content="0;url="https://www.google.com" />';
            exit;
     }
     }
}
?>
