<?php
header('Content-Type: text/html; charset=utf-8');

if (is_login() == false) {
    sMSG('Morate se ulogovati.', 'error');
    redirect_to('home');
    die();
}

$Server_ID = txt($_GET['id']);

if (is_valid_server($Server_ID) == false) {
    sMSG('Ovaj server ne postoji ili za njega nemate pristup.', 'error');
    redirect_to('servers');
    die();
}

if (ban_ftp($_SESSION['user_login']) == 1) {
    sMSG('Va&scaron; nalog je na na&scaron;oj ban listi za ovu stranicu. Ukoliko mislite da je ovo neka gre&scaron;ka obratite se na&scaron;em support timu!', 'info');
    redirect_to('home');
    die();
}

// helper za HTML escape s UTF-8
function h($str) {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

// ------------------------------------------------------
// FTP putanja
// ------------------------------------------------------
$path = '/';

if (isset($_GET['path']) && $_GET['path'] != '') {
    $path = $_GET['path']; // ne koristimo txt() da ne ubija UTF-8
}

// sigurnost - nema .. i duplih /
$path = str_replace('..', '', $path);
$path = preg_replace('#/+#', '/', $path);

if ($path == '') {
    $path = '/';
}

$back_link = '/';
if ($path != '/') {
    $back_link = dirname($path);
    if ($back_link == '.' || $back_link == '\\' || $back_link == '') {
        $back_link = '/';
    }
}

// ------------------------------------------------------
// FTP konekcija
// ------------------------------------------------------
$ftp = @ftp_connect(server_ip($Server_ID), 21);
if (!$ftp) {
    sMSG('Ne mogu se spojiti sa FTP serverom, molimo prijavite ovaj problem podr&scaron;ci.', 'error');
    redirect_to('server?id='.$Server_ID);
    die();
}

if (!@ftp_login($ftp, server_username($Server_ID), server_password($Server_ID))) {
    sMSG('Ne mogu da se prijavim na FTP server, molimo prijavite ovaj problem podr&scaron;ci.', 'error');
    redirect_to('server?id='.$Server_ID);
    die();
}

ftp_pasv($ftp, true);
@ftp_chdir($ftp, $path);

// ------------------------------------------------------
// Akcije (folder, upload, rename, delete, snimi fajl)
// ------------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = isset($_POST['action']) ? $_POST['action'] : '';

    switch ($action) {
        case 'mkdir':
            $name = trim($_POST['name']);
            if ($name !== '') {
                @ftp_mkdir($ftp, ($path == '/' ? '' : $path.'/').$name);
            }
            redirect_to('webftp?id='.$Server_ID.'&path='.$path);
            die();
        break;

        case 'delete':
            $target = trim($_POST['target']);
            $type   = isset($_POST['type']) ? $_POST['type'] : 'file';
            $full   = ($path == '/' ? '' : $path.'/').$target;

            if ($type === 'dir') {
                @ftp_rmdir($ftp, $full); // radi samo na praznim folderima
            } else {
                @ftp_delete($ftp, $full);
            }

            redirect_to('webftp?id='.$Server_ID.'&path='.$path);
            die();
        break;

        case 'rename':
            $old = trim($_POST['old']);
            $new = trim($_POST['new']);

            if ($old !== '' && $new !== '') {
                @ftp_rename($ftp, ($path == '/' ? '' : $path.'/').$old, ($path == '/' ? '' : $path.'/').$new);
            }

            redirect_to('webftp?id='.$Server_ID.'&path='.$path);
            die();
        break;

        case 'upload':
            if (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) {
                $tmp  = $_FILES['file']['tmp_name'];
                $name = $_FILES['file']['name'];
                $dest = ($path == '/' ? '' : $path.'/').$name;

                $fh = fopen($tmp, 'r');
                if ($fh) {
                    @ftp_fput($ftp, $dest, $fh, FTP_BINARY);
                    fclose($fh);
                }
            }

            redirect_to('webftp?id='.$Server_ID.'&path='.$path);
            die();
        break;

        case 'save_file':
            $file_name = trim($_POST['fajl']);
            $content   = isset($_POST['content']) ? $_POST['content'] : '';

            if ($file_name !== '') {
                $remote = ($path == '/' ? '' : $path.'/').$file_name;

                $temp = fopen('php://temp', 'r+');
                fwrite($temp, $content);
                rewind($temp);
                @ftp_fput($ftp, $remote, $temp, FTP_BINARY);
                fclose($temp);
            }

            redirect_to('webftp?id='.$Server_ID.'&path='.$path.'&fajl='.urlencode($file_name));
            die();
        break;
    }
}

// ------------------------------------------------------
// Ucitavanje liste ili sadraja fajla
// ------------------------------------------------------
$current_file  = '';
$file_contents = '';

$ftp_dirs  = array();
$ftp_files = array();

if (isset($_GET['fajl']) && $_GET['fajl'] != '') {
    $current_file = $_GET['fajl']; // ne kroz txt() zbog UTF-8
    $remotePath   = ($path == '/' ? '' : $path.'/').$current_file;

    $temp = fopen('php://temp', 'r+');
    if (@ftp_fget($ftp, $temp, $remotePath, FTP_BINARY)) {
        rewind($temp);
        $file_contents = stream_get_contents($temp);
    }
    fclose($temp);

} else {
    $raw = @ftp_rawlist($ftp, '.');
    if ($raw !== false) {
        foreach ($raw as $line) {
            $chunks = preg_split('/\s+/', $line, 9);
            if (count($chunks) < 9) {
                continue;
            }

            $perm = $chunks[0];
            $size = $chunks[4];
            $date = $chunks[5].' '.$chunks[6].' '.$chunks[7];
            $name = $chunks[8];

            if ($name == '.' || $name == '..') {
                continue;
            }

            $entry = array(
                'perm' => $perm,
                'size' => $size,
                'date' => $date,
                'name' => $name,
            );

            if ($perm[0] === 'd') {
                $ftp_dirs[] = $entry;
            } else {
                $ftp_files[] = $entry;
            }
        }
    }
}

ftp_close($ftp);

// ------------------------------------------------------
// Formatiranje velicine (B/KB/MB...)
// ------------------------------------------------------
function format_bytes_webftp($bytes)
{
    $bytes = (float)$bytes;
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    $i = 0;

    while ($bytes >= 1024 && $i < count($units) - 1) {
        $bytes /= 1024;
        $i++;
    }

    if ($i == 0) {
        return $bytes.' '.$units[$i];
    }

    return round($bytes, 0).' '.$units[$i];
}

// breadcrumbs (koristit cemo ga u headeru tabele)
$breadcrumbs_html = '<a style="color:#FFF;" href="webftp?id='.$Server_ID.'&path=/"><i class="fa fa-home"></i> root</a>';

if ($path != '/') {
    $parts = explode('/', trim($path, '/'));
    $accum = '';
    foreach ($parts as $part) {
        if ($part === '') continue;
        $accum .= '/'.$part;
        $breadcrumbs_html .= ' <i class="fa fa-chevron-right"></i> ';
        $breadcrumbs_html .= '<a style="color:#FFF;" href="webftp?id='.$Server_ID.'&path='.$accum.'"><i class="fa fa-folder-open"></i> '.h($part).'</a>';
    }
}
?>
<div class="container">
    <div class="rows">
        <div class="contect">
            <?php include_once($_SERVER['DOCUMENT_ROOT'].'/core/pages/partial/nav.php'); ?>

            <div class="col-md-9">
                <span class="server-name"><?php echo server_name($Server_ID); ?></span>
            </div>

            <?php include_once($_SERVER['DOCUMENT_ROOT'].'/core/pages/partial/komande.php'); ?>
            <div class="space1"></div>

            <div class="col-md-12">
                <div id="ftp_container">
                    <div id="ftp_header">
                        <div id="left_header">
                            <div style="margin-top:5px;color:#fff;">
                                <strong>WebFTP</strong>
                                <p style="margin: 8px 0 0 0;">
                                    Ovde mo&#382;ete direktno upravljati fajlovima na Va&#353;em serveru
                                    (upload, brisanje, preimenovanje i ure&#273;ivanje fajlova).
                                </p>
                            </div>
                        </div>
                    </div>

                    <div id="plugin_body" style="margin-top:10px;">
                        <div class="row">
                            <div class="col-md-8">
                                <!-- vie nema extra file_info diva, breadcrumb ce biti u headeru tabele -->
                            </div>
                            <div class="col-md-4 text-right">
                                <form action="" method="POST" enctype="multipart/form-data" class="form-inline" style="margin-bottom:4px;">
                                    <input type="hidden" name="action" value="upload">
                                    <input type="file" name="file" class="form-control input-sm" style="display:inline-block;width:55%;">
                                    <button class="btn btn-success btn-sm" type="submit">
                                        <i class="fa fa-upload"></i> Upload
                                    </button>
                                </form>

                                <form action="" method="POST" class="form-inline">
                                    <input type="hidden" name="action" value="mkdir">
                                    <input type="text" name="name" class="form-control input-sm" placeholder="Naziv foldera" style="display:inline-block;width:55%;">
                                    <button class="btn btn-primary btn-sm" type="submit">
                                        <i class="fa fa-folder-plus"></i> Novi folder
                                    </button>
                                </form>
                            </div>
                        </div>

                        <?php if ($current_file == '') { ?>
                            <!-- bez table-striped da nema bijelih redova -->
                            <table class="table table-bordered tabela-asd" style="margin-top:5px;">
                                <thead>
                                    <!-- PRVI RED: root / path (u istoj "visini" kao tabela) -->
                                    <tr>
                                        <th colspan="5" style="text-align:left;">
                                            <?php echo $breadcrumbs_html; ?>
                                        </th>
                                    </tr>
                                    <!-- DRUGI RED: klasicni naslovi kolona -->
                                    <tr>
                                        <th>Ime</th>
                                        <th>Veli&#269;ina</th>
                                        <th>Permisije</th>
                                        <th>Datum</th>
                                        <th style="width:80px;">Opcije</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($path != '/') { ?>
                                        <tr>
                                            <td>
                                                <a href="webftp?id=<?php echo $Server_ID; ?>&path=<?php echo h($back_link); ?>">
                                                    <i class="fa fa-level-up-alt"></i> ..
                                                </a>
                                            </td>
                                            <td>-</td>
                                            <td>-</td>
                                            <td>-</td>
                                            <td></td>
                                        </tr>
                                    <?php } ?>

                                    <?php foreach ($ftp_dirs as $dir) { ?>
                                        <tr>
                                            <td>
                                                <a href="webftp?id=<?php echo $Server_ID; ?>&path=<?php echo h(($path == '/' ? '' : $path).'/'.$dir['name']); ?>">
                                                    <i class="fa fa-folder-open" style="color:yellow;"></i>
                                                    <?php echo h($dir['name']); ?>
                                                </a>
                                            </td>
                                            <td>-</td>
                                            <td><?php echo h($dir['perm']); ?></td>
                                            <td><?php echo h($dir['date']); ?></td>
                                            <td>
                                                <button type="button"
                                                        class="btn btn-primary btn-xs"
                                                        data-name="<?php echo h($dir['name']); ?>"
                                                        onclick="openRenameModal(this);">
                                                    <i class="fa fa-edit"></i>
                                                </button>

                                                <form action="" method="POST" style="display:inline-block;margin-left:3px;">
                                                    <input type="hidden" name="action" value="delete">
                                                    <input type="hidden" name="type" value="dir">
                                                    <input type="hidden" name="target" value="<?php echo h($dir['name']); ?>">
                                                    <button class="btn btn-danger btn-xs" type="submit" onclick="return confirm('Obrisati folder?');">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php } ?>

                                    <?php foreach ($ftp_files as $file) { ?>
                                        <tr>
                                            <td>
                                                <a href="webftp?id=<?php echo $Server_ID; ?>&path=<?php echo h($path); ?>&fajl=<?php echo urlencode($file['name']); ?>" style="color:#bfd5ff;">
                                                    <i class="fa fa-file"></i>
                                                    <?php echo h($file['name']); ?>
                                                </a>
                                            </td>
                                            <td><?php echo format_bytes_webftp($file['size']); ?></td>
                                            <td><?php echo h($file['perm']); ?></td>
                                            <td><?php echo h($file['date']); ?></td>
                                            <td>
                                                <button type="button"
                                                        class="btn btn-primary btn-xs"
                                                        data-name="<?php echo h($file['name']); ?>"
                                                        onclick="openRenameModal(this);">
                                                    <i class="fa fa-edit"></i>
                                                </button>

                                                <form action="" method="POST" style="display:inline-block;margin-left:3px;">
                                                    <input type="hidden" name="action" value="delete">
                                                    <input type="hidden" name="type" value="file">
                                                    <input type="hidden" name="target" value="<?php echo h($file['name']); ?>">
                                                    <button class="btn btn-danger btn-xs" type="submit" onclick="return confirm('Obrisati fajl?');">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        <?php } else { ?>
                            <div id="ftp_sacuvajFile" style="margin-top:10px;">
                                <div style="margin-bottom:5px;color:#fff;">
                                    <?php echo $breadcrumbs_html; ?>
                                    &nbsp;&nbsp;<i class="fa fa-caret-right"></i>
                                    <i class="fa fa-file"></i>
                                    <?php echo h($current_file); ?>
                                </div>

                                <form action="" method="POST">
                                    <input type="hidden" name="action" value="save_file">
                                    <input type="hidden" name="fajl" value="<?php echo h($current_file); ?>">
                                    <textarea id="file_edit" name="content" style="width:100%;min-height:400px;"><?php echo h($file_contents); ?></textarea>
                                    <div class="tiket_info">
                                        <button class="right btn btn-success" style="margin: 10px 10px -3px 0px;">
                                            <i class="fa fa-save"></i> Sa&#269;uvaj
                                        </button>
                                        <div class="clear"></div>
                                    </div>
                                </form>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- POPUP ZA PREIMENOVANJE (transparentan) -->
<style>
#rename_modal {
    display:none;
    position:fixed;
    z-index:9999;
    top:0;
    left:0;
    width:100%;
    height:100%;
    background:rgba(0,0,0,0.6);
}

#rename_modal .modal-inner {
    max-width:420px;
    margin:10% auto;
    padding:20px 25px;
    border-radius:6px;
    background:rgba(9,18,32,0.95);
    border:1px solid rgba(255,255,255,0.08);
    box-shadow:0 0 20px rgba(0,0,0,0.8);
}

#rename_modal h4 {
    margin:0 0 10px 0;
    color:#fff;
    font-size:16px;
}

#rename_modal p,
#rename_modal label {
    color:#ccc;
    font-size:13px;
    margin-bottom:5px;
}
</style>

<div id="rename_modal">
    <div class="modal-inner">
        <h4><i class="fa fa-user-edit"></i> Promijeni ime foldera/fajla</h4>
        <p>Trenutno ime: <strong id="rename_current_name" style="color:#fff;"></strong></p>

        <form method="POST" action="">
            <input type="hidden" name="action" value="rename">
            <input type="hidden" name="old" id="rename_old_input" value="">

            <div class="form-group">
                <label>* Unesite novo ime</label>
                <input type="text" name="new" id="rename_new_input" class="form-control" autocomplete="off">
            </div>

            <div style="margin-top:15px; text-align:right;">
                <button type="submit" class="btn btn-success">
                    <i class="fa fa-check"></i> Promijeni
                </button>
                <button type="button" class="btn btn-default" onclick="closeRenameModal();" style="margin-left:5px;">
                    <i class="fa fa-times"></i> Otka&#382;i
                </button>
            </div>
        </form>
    </div>
</div>

<script>
function openRenameModal(btn) {
    var name = btn.getAttribute('data-name');

    document.getElementById('rename_current_name').innerText = name;
    document.getElementById('rename_old_input').value = name;
    document.getElementById('rename_new_input').value = name;

    document.getElementById('rename_modal').style.display = 'block';
}

function closeRenameModal() {
    document.getElementById('rename_modal').style.display = 'none';
}
</script>
