<?php
header('Content-Type: text/html; charset=utf-8');
include_once($_SERVER['DOCUMENT_ROOT'].'/admin/head.php');

$Server_ID = txt($_GET['id']);

if (is_valid_server($Server_ID) == false) {
    sMSG('Ovaj server ne postoji ili za njega nemate pristup.', 'error');
    redirect_to('gp-servers.php');
    die();
}

if (cp_perm_srv_view($Server_ID) == false) {
    sMSG('Niste support za ovu igru!', 'info');
    redirect_to('gp-servers.php');
    die();
}

// helper za HTML escape
function h($str) {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

// dozvoljene ekstenzije za edit fajla
$allowed_ext = array(
    "txt","sma","SMA","cfg","CFG","inf","log","rc","ini",
    "yml","json","properties","conf"
);

error_reporting(0);

// ------------------------------------------------------
// FTP putanja (bez txt(), ali uz osnovnu sigurnost)
// ------------------------------------------------------
$path = '/';

if (isset($_GET['path']) && $_GET['path'] != '') {
    $path = $_GET['path']; // ne koristimo txt() da ne ubije UTF-8
}

$path = str_replace('..', '', $path);
$path = preg_replace('#/+#', '/', $path);

if ($path == '') {
    $path = '/';
}

$back_link = '/';
if ($path != '/') {
    $back_link = dirname($path);
    if ($back_link == '.' || $back_link == '\\' || $back_link == '') {
        $back_link = '/';
    }
}

// ------------------------------------------------------
// Formatiranje velicine (B/KB/MB/GB)
// ------------------------------------------------------
function format_bytes_webftp_admin($bytes)
{
    if ($bytes === "link fajla") {
        return $bytes;
    }

    $bytes = (float)$bytes;
    $units = array('B', 'KB', 'MB', 'GB', 'TB');
    $i = 0;

    while ($bytes >= 1024 && $i < count($units) - 1) {
        $bytes /= 1024;
        $i++;
    }

    if ($i == 0) {
        return $bytes.' '.$units[$i];
    }

    return round($bytes, 0).' '.$units[$i];
}

// ------------------------------------------------------
// FTP akcije (upload, mkdir, rename)
// ------------------------------------------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['gp_action'])) {
    $action = $_POST['gp_action'];

    $ftp = @ftp_connect(server_ip($Server_ID), 21);
    if (!$ftp || !@ftp_login($ftp, server_username($Server_ID), server_password($Server_ID))) {
        sMSG('Ne mogu se spojiti sa FTP serverom, molimo prijavite naoj podrci ovaj problem.', 'error');
        redirect_to('gp-webftp.php?id='.$Server_ID.'&path='.$path);
        die();
    }

    ftp_pasv($ftp, true);
    @ftp_chdir($ftp, $path);

    switch ($action) {
        case 'mkdir':
            $name = trim($_POST['name']);
            if ($name !== '') {
                @ftp_mkdir($ftp, ($path == '/' ? '' : $path.'/').$name);
            }
        break;

        case 'upload':
            if (isset($_FILES['file']) && $_FILES['file']['error'] === UPLOAD_ERR_OK) {
                $tmp  = $_FILES['file']['tmp_name'];
                $name = $_FILES['file']['name'];
                $dest = ($path == '/' ? '' : $path.'/').$name;

                $fh = fopen($tmp, 'r');
                if ($fh) {
                    @ftp_fput($ftp, $dest, $fh, FTP_BINARY);
                    fclose($fh);
                }
            }
        break;

        case 'rename':
            $old = trim($_POST['old']);
            $new = trim($_POST['new']);
            if ($old !== '' && $new !== '' && $old !== $new) {
                @ftp_rename(
                    $ftp,
                    ($path == '/' ? '' : $path.'/').$old,
                    ($path == '/' ? '' : $path.'/').$new
                );
            }
        break;
    }

    ftp_close($ftp);
    redirect_to('gp-webftp.php?id='.$Server_ID.'&path='.$path);
    die();
}

// ------------------------------------------------------
// NAV / TABOVI (original, ne diramo)
// ------------------------------------------------------
?>

<!-- Main -->
<div class="main">
    <div class="main-inner">
        <div class="container">
            <div class="row">
                
                <!-- SERVER INFO -->
                <div class="span12">
                    <div class="navbar">
                        <div class="navbar-inner">
                            <ul class="nav">
                                <li class="nav_s_active"><a href="/admin/gp-server.php?id=<?php echo $Server_ID; ?>">Server</a></li>
                                <?php if (gp_game_id($Server_ID) == 1) { ?>
                                    <li><a href="/admin/gp-admins.php?id=<?php echo $Server_ID; ?>">Admini i slotovi</a></li>
                                    <li><a href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>">WebFTP</a></li>
                                    <li><a href="/admin/gp-plugins.php?id=<?php echo $Server_ID; ?>">Plugini</a></li>
                                    <li><a href="/admin/gp-maps.php?id=<?php echo $Server_ID; ?>">Map installer</a></li>
                                    <li><a href="/admin/gp-mods.php?id=<?php echo $Server_ID; ?>">Modovi</a></li>
                                    <li><a href="/admin/gp-console.php?id=<?php echo $Server_ID; ?>">Konzola</a></li>
                                    <li><a href="/admin/gp-boost.php?id=<?php echo $Server_ID; ?>">Boost</a></li>
                                    <li><a href="/admin/gp-autorestart.php?id=<?php echo $Server_ID; ?>">Autorestart</a></li>
                                    <li><a href="/admin/gp-backup.php?id=<?php echo $Server_ID; ?>">Backup</a></li>
                                <?php } else if (gp_game_id($Server_ID) == 2) { ?>
                                    <li><a href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>">WebFTP</a></li>
                                    <li><a href="/admin/gp-mods.php?id=<?php echo $Server_ID; ?>">Modovi</a></li>
                                    <li><a href="/admin/gp-console.php?id=<?php echo $Server_ID; ?>">Konzola</a></li>
                                    <li><a href="/admin/gp-autorestart.php?id=<?php echo $Server_ID; ?>">Autorestart</a></li>
                                    <li><a href="/admin/gp-backup.php?id=<?php echo $Server_ID; ?>">Backup</a></li>
                                <?php } else if (gp_game_id($Server_ID) == 3) { ?>
                                    <li><a href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>">WebFTP</a></li>
                                    <li><a href="/admin/gp-mods.php?id=<?php echo $Server_ID; ?>">Modovi</a></li>
                                    <li><a href="/admin/gp-console.php?id=<?php echo $Server_ID; ?>">Konzola</a></li>
                                    <li><a href="/admin/gp-autorestart.php?id=<?php echo $Server_ID; ?>">Autorestart</a></li>
                                    <li><a href="/admin/gp-backup.php?id=<?php echo $Server_ID; ?>">Backup</a></li>
                                <?php } else if (gp_game_id($Server_ID) == 4) { ?>
                                    <li><a href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>">WebFTP</a></li>
                                    <li><a href="/admin/gp-plugins.php?id=<?php echo $Server_ID; ?>">Plugini</a></li>
                                    <li><a href="/admin/gp-mods.php?id=<?php echo $Server_ID; ?>">Modovi</a></li>
                                    <li><a href="/admin/gp-console.php?id=<?php echo $Server_ID; ?>">Konzola</a></li>
                                    <li><a href="/admin/gp-autorestart.php?id=<?php echo $Server_ID; ?>">Autorestart</a></li>
                                    <li><a href="/admin/gp-backup.php?id=<?php echo $Server_ID; ?>">Backup</a></li>
                                <?php } else if (gp_game_id($Server_ID) == 5) { ?>
                                    <li><a href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>">WebFTP</a></li>
                                    <li><a href="/admin/gp-plugins.php?id=<?php echo $Server_ID; ?>">Plugini</a></li>
                                    <li><a href="/admin/gp-mods.php?id=<?php echo $Server_ID; ?>">Modovi</a></li>
                                    <li><a href="/admin/gp-console.php?id=<?php echo $Server_ID; ?>">Konzola</a></li>
                                    <li><a href="/admin/gp-autorestart.php?id=<?php echo $Server_ID; ?>">Autorestart</a></li>
                                    <li><a href="/admin/gp-backup.php?id=<?php echo $Server_ID; ?>">Backup</a></li>
                                <?php } else if (gp_game_id($Server_ID) == 6) { ?>
                                    <li><a href="/admin/ts-perm.php?id=<?php echo $Server_ID; ?>">Permission</a></li>
                                    <li><a href="/admin/ts-bans.php?id=<?php echo $Server_ID; ?>">Banovani</a></li>
                                <?php } else if (gp_game_id($Server_ID) == 7) { ?>  
                                    <li><a href="/admin/gp-admins.php?id=<?php echo $Server_ID; ?>">Admini i slotovi</a></li>
                                    <li><a href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>">WebFTP</a></li>
                                    <li><a href="/admin/gp-plugins.php?id=<?php echo $Server_ID; ?>">Plugini</a></li>
                                    <li><a href="/admin/gp-mods.php?id=<?php echo $Server_ID; ?>">Modovi</a></li>
                                    <li><a href="/admin/gp-console.php?id=<?php echo $Server_ID; ?>">Konzola</a></li>
                                    <li><a href="/admin/gp-boost.php?id=<?php echo $Server_ID; ?>">Boost</a></li>
                                    <li><a href="/admin/gp-autorestart.php?id=<?php echo $Server_ID; ?>">Autorestart</a></li>
                                    <li><a href="/admin/gp-backup.php?id=<?php echo $Server_ID; ?>">Backup</a></li>
                                <?php } else if (gp_game_id($Server_ID) == 8) { ?>
                                    <li><a href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>">WebFTP</a></li>
                                    <li><a href="/admin/gp-mods.php?id=<?php echo $Server_ID; ?>">Modovi</a></li>
                                    <li><a href="/admin/gp-console.php?id=<?php echo $Server_ID; ?>">Konzola</a></li>
                                    <li><a href="/admin/gp-autorestart.php?id=<?php echo $Server_ID; ?>">Autorestart</a></li>
                                    <li><a href="/admin/gp-backup.php?id=<?php echo $Server_ID; ?>">Backup</a></li>
                                <?php } else if (gp_game_id($Server_ID) == 9) { ?>
                                    <li><a href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>">WebFTP</a></li>
                                    <li><a href="/admin/gp-mods.php?id=<?php echo $Server_ID; ?>">Modovi</a></li>
                                    <li><a href="/admin/gp-console.php?id=<?php echo $Server_ID; ?>">Konzola</a></li>
                                    <li><a href="/admin/gp-autorestart.php?id=<?php echo $Server_ID; ?>">Autorestart</a></li>
                                    <li><a href="/admin/gp-backup.php?id=<?php echo $Server_ID; ?>">Backup</a></li>
                                <?php } ?>
                                <li><a href="" data-toggle="modal" data-target="#jesi_siguran"><i class="icon-share-alt"></i> Prebaci server</a></li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- server + klijent ime (original) -->
                <div class="span12">
                    <div class="widget stacked">
                        <div class="widget-header">
                            <h3>
                                <i class="fa fa-gamepad"></i>
                                <a href="/admin/gp-server.php?id=<?php echo $Server_ID; ?>">
                                    <?php echo server_name($Server_ID); ?>
                                </a> 
                                |
                                <i class="fa fa-user"></i> 
                                <a href="/admin/gp-klijent.php?id=<?php echo Srw_Owenr($Server_ID); ?>">
                                    <?php echo user_full_name(Srw_Owenr($Server_ID)); ?>
                                </a>
                            </h3>
                        </div>
                    </div>
                </div>
                
                <!-- WEBFTP TABLICA -->
                <div class="span12">
                    <div class="widget widget-table action-table">
                        <div class="widget-header">
                            <h3><i class="icon-th-list"></i> WebFTP</h3>
                        </div>

                        <div class="widget-content">

<?php
// ---------------- FTP LISTING / BREADCRUMB ----------------
if (!isset($_GET['path'])) {
    redirect_to('gp-webftp.php?id='.$Server_ID.'&path=/');
    die();
}

$ftp_path    = ltrim($path, '/');
$breadcrumbs = preg_split('/[\/]+/', $ftp_path, 9); 
$breadcrumbs = str_replace("/", "", $breadcrumbs);

$ftp_pth = '';
if(($bsize = sizeof($breadcrumbs)) > 0) {
    $sofar = '';
    for($bi=0;$bi<$bsize;$bi++) {
        if($breadcrumbs[$bi]) {
            $sofar = $sofar . $breadcrumbs[$bi] . '/';
            $ftp_pth .= '<i class="fa fa-chevron-right"></i>
                <a style="color:#FFF;" href="/admin/gp-webftp.php?id='.$Server_ID.'&path=/'.$sofar.'">
                <i class="fa fa-folder-open"></i> '.h($breadcrumbs[$bi]).'</a>';
        }
    }
}

$ftp_dir  = array();
$ftp_fajl = array();

$ftp = ftp_connect(server_ip($Server_ID), 21);
if(!$ftp) {
    sMSG('Ne mogu se spojiti sa FTP serverom, molimo prijavite naoj podrci ovaj problem.', 'error');
    redirect_to('gp-server.php?id='.$Server_ID);
    die();
}

if (@ftp_login($ftp, server_username($Server_ID), server_password($Server_ID))) {
    ftp_pasv($ftp, true);
    if (!isset($_GET['fajl'])) {
        ftp_chdir($ftp, $path);
        $ftp_contents = ftp_rawlist($ftp, $path);
        $i = 0;

        foreach ($ftp_contents as $folder) {
            $broj = $i++;   
            $current = preg_split("/[\s]+/",$folder,9);

            $isdir = ftp_size($ftp, $current[8]);
            if (substr($current[0][0], 0 - 1) == "l"){
                $xa = explode("->", $current[8]);
                $current[8] = $xa[0];
                $current[0] = "link";
                $current[4] = "link fajla";
                $ftp_fajl[]=$current;
            } else {
                if ( substr( $current[0][0], 0 - 1 ) == "d" ) {
                    $ftp_dir[]=$current;
                } else {
                    $ext = explode(".", $current[8]);
                    if(!empty($ext[1])) if (in_array($ext[1], $allowed_ext)) $current[9] = $ext[1];
                    $ftp_fajl[]=$current;
                }
            }   
        }

    } else {
        $filename = 'ftp://'.server_username($Server_ID).':'.server_password($Server_ID).'@'.server_ip($Server_ID).':21/'.$_GET['path'].'/'.$_GET['fajl'];
        $contents = file_get_contents($filename);
    }

    $old_path = $path.'/';
    $old_path = str_replace('//', '/', $old_path);
} else {
    sMSG('Ne mogu se spojiti sa FTP serverom, molimo prijavite naoj podrci ovaj problem.', 'error');
    redirect_to('gp-server.php?id='.$Server_ID);
    die();
}

ftp_close($ftp);
?>

                            <div id="ftp_container">

                                <div id="plugin_body" style="margin-top:8px;">

                                    <!-- root lijevo, upload + novi folder desno ISTI RED -->
                                    <div style="margin-bottom:6px; overflow:hidden;">
                                        <div style="float:left; color:#fff;">
                                            <a style="color:#FFF;" href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>">
                                                <i class="fa fa-home"></i> root
                                            </a>
                                            <?php echo $ftp_pth; ?>
                                            <?php if (isset($_GET['fajl'])) { ?>
                                                <i class="fa fa-caret-right"></i>
                                                <i class="fa fa-file"></i> <?php echo h($_GET['fajl']); ?>
                                            <?php } ?>
                                        </div>

                                        <div style="float:right; text-align:right;">
                                            <form action="" method="POST" enctype="multipart/form-data" style="display:inline-block; margin:0 5px 3px 0;">
                                                <input type="hidden" name="gp_action" value="upload">
                                                <input type="file" name="file" class="input-small" style="display:inline-block;width:55%;">
                                                <button class="btn btn-success btn-small" type="submit">
                                                    <i class="fa fa-upload"></i> Upload
                                                </button>
                                            </form>

                                            <form action="" method="POST" style="display:inline-block; margin:0;">
                                                <input type="hidden" name="gp_action" value="mkdir">
                                                <input type="text" name="name" class="input-small" placeholder="Naziv foldera" style="display:inline-block;width:55%;">
                                                <button class="btn btn-primary btn-small" type="submit">
                                                    <i class="fa fa-folder-plus"></i> Novi folder
                                                </button>
                                            </form>
                                        </div>

                                        <div style="clear:both;"></div>
                                    </div>

<?php if (!isset($_GET['fajl'])) { ?>

                                    <table class="table table-bordered tabela-asd" style="margin-top:5px;">
                                        <thead>
                                            <tr>
                                                <th>Ime fajla/foldera</th>
                                                <th>Veli&#269;ina</th>
                                                <th>User</th>
                                                <th>Grupa</th>
                                                <th>Permisije</th>
                                                <th>Modifikovan</th>
                                                <th style="width:90px;">Akcija</th>
                                            </tr>
                                        </thead>
                                        <tbody>
<?php
    $back_link = str_replace("\\", '/', $back_link);
    if($path != "/") {
?>
                                            <tr>
                                                <td colspan="7" style="cursor:pointer;" onclick="window.location='?id=<?php echo $Server_ID; ?><?php if ($back_link != "/") { ?>&path=<?php echo h($back_link); } ?>'">
                                                    <z><i class="fa fa-arrow-left"></i></z> &nbsp;...
                                                </td>
                                            </tr>
<?php } ?>

<?php
if (!empty($ftp_dir)) {
    foreach($ftp_dir as $x) {
?>
                                            <tr>
                                                <td>
                                                    <a style="color:#FFF;" href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>&path=<?php echo h($old_path.$x[8]); ?>">
                                                        <i class='fa fa-folder-open' style="color:yellow;"></i>
                                                        <?php echo h($x[8]); ?>
                                                    </a>
                                                </td>
                                                <td>-</td>
                                                <td><?php echo h($x[2]); ?></td>
                                                <td><?php echo h($x[3]); ?></td>
                                                <td><?php echo h($x[0]); ?></td>
                                                <td><?php echo h($x[5].' '.$x[6].' '.$x[7]); ?></td>
                                                <td>
                                                    <!-- rename folder -->
                                                    <button type="button"
                                                            class="btn btn-primary btn-mini rename-btn"
                                                            data-name="<?php echo h($x[8]); ?>">
                                                        <i class="fa fa-edit"></i>
                                                    </button>

                                                    <!-- delete folder (stari modal) -->
                                                    <a href="#" data-toggle="modal" data-target="#folder_dell-auth_<?php echo txt($x[8]); ?>">
                                                        <button type="button" class="btn btn-danger btn-mini">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    </a>
                                                </td>
                                            </tr>

<div id="folder_dell-auth_<?php echo txt($x[8]); ?>" class="modal hide fade" tabindex="-1" role="dialog" aria-hidden="true" style="display:none;outline:none;">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"></button>
        <h4 class="modal-title">Delete folder</h4>
    </div>
    <div class="modal-footer">
        <p class="left">
            <strong> Da li ste sigurni da elite obrisati (<?php echo txt($x[8]); ?>) folder?</strong>
        </p>
        <br />
        <form action="/admin/process.php?a=delete_folder" method="POST" class="left">
            <input type="hidden" name="server_id" value="<?php echo txt($Server_ID); ?>">
            <input type="hidden" name="f_name" value="<?php echo txt($x[8]); ?>">
            <input type="hidden" name="path" value="<?php echo txt($path); ?>">
            <div class="space clear"></div>
            <button class="left btn btn-success">
                <i class="icon-ok"></i> Delete folder
            </button>
        </form>
    </div>
</div>

<?php
    }
}

if (!empty($ftp_fajl)) {
    foreach($ftp_fajl as $x) {
        $exp_f_name  = explode('.', $x[8]);
        $File_auth_m = $exp_f_name[0];
?>
                                            <tr>
                                                <td>
                                                    <?php if(isset($x[9])) { ?>
                                                        <a href="/admin/gp-webftp.php?id=<?php echo $Server_ID; ?>&path=<?php echo h($path); ?>&fajl=<?php echo txt($x[8]); ?>" style="color:#bfd5ff;">
                                                            <i class='fa fa-file-text'></i> <?php echo h($x[8]); ?>
                                                        </a>
                                                    <?php } else { ?>
                                                        <i class='fa fa-file'></i> <?php echo h($x[8]); ?>
                                                    <?php } ?>
                                                </td>
                                                <td><?php echo format_bytes_webftp_admin($x[4]); ?></td>
                                                <td><?php echo h($x[2]); ?></td>
                                                <td><?php echo h($x[3]); ?></td>
                                                <td><?php echo h($x[0]); ?></td>
                                                <td><?php echo h($x[5].' '.$x[6].' '.$x[7]); ?></td>
                                                <td>
                                                    <!-- rename file -->
                                                    <button type="button"
                                                            class="btn btn-primary btn-mini rename-btn"
                                                            data-name="<?php echo h($x[8]); ?>">
                                                        <i class="fa fa-edit"></i>
                                                    </button>

                                                    <!-- delete file -->
                                                    <a href="#" data-toggle="modal" data-target="#file_dell_<?php echo txt($File_auth_m); ?>">
                                                        <button type="button" class="btn btn-danger btn-mini">
                                                            <i class="fa fa-trash"></i>
                                                        </button>
                                                    </a>
                                                </td>
                                            </tr>

<div id="file_dell_<?php echo txt($File_auth_m); ?>" class="modal hide fade" tabindex="-1" role="dialog" aria-hidden="true" style="display:none;outline:none;">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"></button>
        <h4 class="modal-title">Delete file</h4>
    </div>
    <div class="modal-footer">
        <p class="left">
            <strong> Da li ste sigurni da elite obrisati (<?php echo txt($x[8]); ?>) file?</strong>
        </p>
        <br />
        <form action="/admin/process.php?a=delete_file" method="POST" class="left">
            <input type="hidden" name="server_id" value="<?php echo txt($Server_ID); ?>">
            <input type="hidden" name="f_name" value="<?php echo txt($x[8]); ?>">
            <input type="hidden" name="path" value="<?php echo txt($path); ?>">
            <div class="space clear"></div>
            <button class="left btn btn-success">
                <i class="icon-ok"></i> Delete file
            </button>
        </form>
    </div>
</div>

<?php
    }
}
?>
                                        </tbody>
                                    </table>

<?php } else { ?>

                                    <div id="ftp_sacuvajFile" style="margin-top:10px;">
                                        <form action="/admin/process.php?a=save_ftp_file" method="POST">
                                            <input type="hidden" name="f_name" value="<?php echo txt($_GET['fajl']); ?>" />
                                            <input type="hidden" name="path" value="<?php echo h($path); ?>" />
                                            <input type="hidden" name="server_id" value="<?php echo $Server_ID; ?>" />
                                            <textarea id="file_edit" name="file_text_edit" height="auto"><?php echo htmlspecialchars($contents); ?></textarea>
                                            <div class="tiket_info">
                                                <button class="right btn btn-success" style="margin: 10px 10px -3px 0px;">  
                                                    <i class="fa fa-save"></i> Sacuvaj 
                                                </button>
                                                <div class="clear"></div>
                                            </div>
                                        </form>     
                                    </div>

<?php } ?>

                                </div><!-- /plugin_body -->
                            </div><!-- /ftp_container -->

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Prebaci server modal (original) -->
<div id="jesi_siguran" class="modal hide fade" tabindex="-1" role="dialog" aria-hidden="true" style="display:none;outline:none;">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal"></button>
        <h4 class="modal-title">Prebaci server</h4>
    </div>
    <div class="modal-footer">
        <form action="/admin/process.php?a=change_owner" method="POST" class="left">
            <input type="text" name="server_id" value="<?php echo $Server_ID; ?>" style="display:none;">
            <select name="client_id" class="selectpicker" data-live-search="true">
                <option value="0" disabled selected="selected">Izaberite klijenta</option>
                <?php $get_clients = mysql_query("SELECT * FROM `klijenti` ORDER by klijentid ASC");
                while ($row_client = mysql_fetch_array($get_clients)) { ?>
                    <option value="<?php echo txt($row_client['klijentid']); ?>" style="color:#333;">
                        <?php echo user_full_name($row_client['klijentid']).' - '.user_email($row_client['klijentid']); ?>
                    </option>
                <?php } ?>
            </select>
            <div class="space clear"></div>
            <button class="left btn btn-success">
                <i class="icon-ok"></i> Prebaci
            </button>
        </form>
    </div>
</div>

<!-- GLOBALNI RENAME MODAL -->
<style>
#rename_modal_admin {
    display:none;
    position:fixed;
    z-index:9999;
    top:0;
    left:0;
    width:100%;
    height:100%;
    background:rgba(0,0,0,0.6);
}
#rename_modal_admin .modal-inner {
    max-width:420px;
    margin:10% auto;
    padding:20px 25px;
    border-radius:6px;
    background:rgba(9,18,32,0.95);
    border:1px solid rgba(255,255,255,0.08);
    box-shadow:0 0 20px rgba(0,0,0,0.8);
}
#rename_modal_admin h4 {
    margin:0 0 10px 0;
    color:#fff;
    font-size:16px;
}
#rename_modal_admin p,
#rename_modal_admin label {
    color:#ccc;
    font-size:13px;
    margin-bottom:5px;
}
</style>

<div id="rename_modal_admin">
    <div class="modal-inner">
        <h4><i class="fa fa-user-edit"></i> Promijeni ime foldera/fajla</h4>
        <p>Trenutno ime: <strong id="rename_current_name_admin" style="color:#fff;"></strong></p>

        <form method="POST" action="">
            <input type="hidden" name="gp_action" value="rename">
            <input type="hidden" name="old" id="rename_old_input_admin" value="">

            <div class="form-group">
                <label>* Unesite novo ime</label>
                <input type="text" name="new" id="rename_new_input_admin" class="input-xlarge" autocomplete="off">
            </div>

            <div style="margin-top:15px; text-align:right;">
                <button type="submit" class="btn btn-success">
                    <i class="fa fa-check"></i> Promijeni
                </button>
                <button type="button" class="btn btn-default" onclick="closeRenameModalAdmin();" style="margin-left:5px;">
                    <i class="fa fa-times"></i> Otkai
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// za sva dugmad sa .rename-btn otvori modal i popuni ime
document.addEventListener('DOMContentLoaded', function () {
    var buttons = document.querySelectorAll('.rename-btn');
    buttons.forEach(function (btn) {
        btn.addEventListener('click', function (e) {
            e.preventDefault();
            var name = this.getAttribute('data-name') || '';
            document.getElementById('rename_current_name_admin').innerText = name;
            document.getElementById('rename_old_input_admin').value = name;
            document.getElementById('rename_new_input_admin').value = name;
            document.getElementById('rename_modal_admin').style.display = 'block';
        });
    });
});

function closeRenameModalAdmin() {
    document.getElementById('rename_modal_admin').style.display = 'none';
}
</script>

<?php include_once($_SERVER['DOCUMENT_ROOT'].'/admin/footer.php'); ?>
<?php include_once($_SERVER['DOCUMENT_ROOT'].'/admin/assets/php/java.php'); ?>
