<?php

/**
* 
*/

function is_money($u_id) {
    // koliko korisnik realno ima para
    $my_money = money_val_code(my_money($u_id), my_contry($u_id)); 

    // cijena 12 slotova za CS 1.6 na lite1 lokaciji za tog korisnika
    $cena = cena_slota_code(12, 1, 'lite1', $u_id);

    // pretvori u brojeve da ne poredi stringove
    $my_money_val = floatval($my_money);
    $cena_val     = floatval($cena);

    return ($cena_val <= $my_money_val);
}

function drzava_valuta($d) {
	if($d == "RS") {
		$drzava = "din";
	} else if($d == "HR") {
		$drzava = "kn";
	} else if($d == "BA") {
		$drzava = "km";
	} else if($d == "MK") { 
		$drzava = "den";
	} else if($d == "ME") { 
		$drzava = "&euro;";
	} else if($d == "other") { 
		$drzava = "&euro;";
	}

	return $drzava;
}

function drzava($d) {
	if($d == "RS") {
		$drzava = "Srbija";
	} else if($d == "HR") {
		$drzava = "Hrvatska";
	} else if($d == "BA") {
		$drzava = "Bosna i Hercegovina";
	} else if($d == "MK") { 
		$drzava = "Makedonija";
	} else if($d == "ME") { 
		$drzava = "Montenegro";
	} else if($d == "other") { 
		$drzava = "No Balkan";
	}

	return $drzava;
}

function euro_for_slot($s_id) {
	$g_id = gp_game_id($s_id);
	$rootsec = rootsec();
	
	$SQLSEC = $rootsec->prepare("SELECT * FROM `serveri` WHERE `id` = ?");
	$SQLSEC->Execute(array($s_id));
	$ss_info = $SQLSEC->fetch(PDO::FETCH_ASSOC);
	
	$SQLSEC = $rootsec->prepare("SELECT * FROM `klijenti` WHERE `klijentid` = ?");
	$SQLSEC->Execute(array($ss_info["user_id"]));
	$uu_info = $SQLSEC->fetch(PDO::FETCH_ASSOC);
	
	$SQLSEC = $rootsec->prepare("SELECT * FROM `gp_cene` WHERE `game_id` = ?");
	$SQLSEC->Execute(array($g_id));
	$slot_cena = $SQLSEC->fetch(PDO::FETCH_ASSOC);
	
	$cena_slota = explode('|', $slot_cena['cena_slota']);

	if ($uu_info['zemlja'] == "RS") {
		$cena = $cena_slota[0];
	} else if ($uu_info['zemlja'] == "HR") {
		$cena = $cena_slota[1];
	} else if ($uu_info['zemlja'] == "BA") {
		$cena = $cena_slota[2];
	} else if ($uu_info['zemlja'] == "MK") {
		$cena = $cena_slota[3];
	} else if ($uu_info['zemlja'] == "ME") {
		$cena = $cena_slota[4];
	} else if ($uu_info['zemlja'] == "other") {
		$cena = $cena_slota[0];
	} else {
		$cena = 0;
	}

    // osiguraj da su brojevi
    $cena = floatval($cena);
    $slot = floatval(server_slot($s_id));

	$cenaslota = round($cena * $slot, 2);
	$cenaslota = number_format($cenaslota, 2);
	
	$cenaslota = $cenaslota.' '.drzava_valuta($uu_info['zemlja']); 
	
	return $cenaslota;
}

function cena_slota($slot, $user_id, $game_id) {
	$rootsec = rootsec();
	
	$SQLSEC = $rootsec->prepare("SELECT * FROM `klijenti` WHERE `klijentid` = ?");
	$SQLSEC->Execute(array($user_id));
	$uu_info = $SQLSEC->fetch(PDO::FETCH_ASSOC);
	
	$SQLSEC = $rootsec->prepare("SELECT * FROM `gp_cene` WHERE `game_id` = ?");
	$SQLSEC->Execute(array($game_id));
	$slot_cena = $SQLSEC->fetch(PDO::FETCH_ASSOC);
	
	$cena_slota = explode('|', $slot_cena['cena_slota']);

	if ($uu_info['zemlja'] == "RS") {
		$cena = $cena_slota[0];
	} else if ($uu_info['zemlja'] == "HR") {
		$cena = $cena_slota[1];
	} else if ($uu_info['zemlja'] == "BA") {
		$cena = $cena_slota[2];
	} else if ($uu_info['zemlja'] == "MK") {
		$cena = $cena_slota[3];
	} else if ($uu_info['zemlja'] == "ME") {
		$cena = $cena_slota[4];
	} else if ($uu_info['zemlja'] == "other") {
		$cena = $cena_slota[0];
	} else {
        $cena = 0;
    }

    $cena = floatval($cena);
    $slot = floatval($slot);

	$cenaslota = round($cena * $slot, 2);
	$cenaslota = number_format($cenaslota, 2);
	
	$cenaslota = $cenaslota.' '.drzava_valuta($uu_info['zemlja']); 
	
	return $cenaslota;
}

function mod_cena_for_slot($slot, $game_id, $drzava) {
	$rootsec = rootsec();
	$SQLSEC = $rootsec->prepare("SELECT * FROM `gp_cene` WHERE `game_id` = ?");
	$SQLSEC->Execute(array($game_id));
	$slot_cena = $SQLSEC->fetch(PDO::FETCH_ASSOC);
	
	$cena_slota = explode('|', $slot_cena['cena_slota']);

	if ($drzava == "RS") {
		$cena = $cena_slota[0];
	} else if ($drzava == "HR") {
		$cena = $cena_slota[1];
	} else if ($drzava == "BA") {
		$cena = $cena_slota[2];
	} else if ($drzava == "MK") {
		$cena = $cena_slota[3];
	} else if ($drzava == "ME") {
		$cena = $cena_slota[4];
	} else if ($drzava == "other") {
		$cena = $cena_slota[0];
	} else {
        $cena = 0;
    }

    $cena = floatval($cena);
    $slot = floatval($slot);

	$cenaslota = round($cena * $slot, 2);
	$cenaslota = number_format($cenaslota, 2);
	
	return $cenaslota;
}

function money_num($novac, $drzava) {
	if($drzava == "RS"){
		$novac = $novac*125;
		$novacc = $novac;
		return $novacc;	
	} else if($drzava == "HR"){
		$novac = $novac*6.5;	
		$novacc = $novac;
		return $novacc;		
	} else if($drzava == "BA"){
		$novac = $novac*1.7;		
		$novacc = $novac;
		return $novacc;		
	} else if($drzava == "MK"){
		$novac = $novac*5.36;	
		$novacc = $novac;
		return $novacc;		
	} else if($drzava == "ME" || $drzava == "other"){
		$novacc = $novac;
		return $novacc;		
	}

	return false;
}

function money_val($novac, $drzava) {
	if($drzava == "RS"){
		$novac = $novac*120;	
		$novacc = number_format(floatval($novac), 2).''.drzava_valuta($drzava);
		return $novacc;	
	} else if($drzava == "HR"){
		$novac = $novac*6.5;	
		$novacc = number_format(floatval($novac), 2).''.drzava_valuta($drzava);
		return $novacc;		
	} else if($drzava == "BA"){
		$novac = $novac*1.7;		
		$novacc = number_format(floatval($novac), 2).''.drzava_valuta($drzava);
		return $novacc;		
	} else if($drzava == "MK"){
		$novac = $novac*5.36;	
		$novacc = number_format(floatval($novac), 2).''.drzava_valuta($drzava);
		return $novacc;		
	} else if($drzava == "ME" || $drzava == "other"){	
		$novacc = number_format(floatval($novac), 2).' '.drzava_valuta($drzava);
		return $novacc;		
	}

	return false;
}

// CREATE A NEW GAME SERVER - CLIENT MODE
function cena_slota_code($slot, $game_id = 1, $loc = 'lite1', $cl_id = null) {
    $rootsec = rootsec();

    // ako nije proslijeden klijent, koristi trenutno ulogovanog
    if ($cl_id === null && isset($_SESSION['user_login'])) {
        $cl_id = $_SESSION['user_login'];
    }

    if ($loc == 'premium1' || $loc == 'premium2' || $loc == 'premium3') {

        if ($game_id == 1) {         // cs 1.6
            $cena_slota = explode('|', '61din|3.7kn|0.9km|30mkd|0.50eur');
        } else if ($game_id == 2) {  // samp
            $cena_slota = explode('|', '61din|3.7kn|0.9km|30mkd|0.03eur');
        } else if ($game_id == 3) {  // mc
            $cena_slota = explode('|', '61din|3.7kn|0.9km|30mkd|0.50eur');
        } else if ($game_id == 4) {  // cod2
            $cena_slota = explode('|', '61din|3.7kn|0.9km|30mkd|0.50eur');
        } else if ($game_id == 5) {  // cod4
            $cena_slota = explode('|', '61din|3.7kn|0.9km|30mkd|0.50eur');
        } else if ($game_id == 6) {  // ts3
            $cena_slota = explode('|', '61din|3.7kn|0.9km|30mkd|0.50eur');
        } else if ($game_id == 7) {  // csgo
            $cena_slota = explode('|', '61din|3.7kn|0.9km|30mkd|0.50eur');
        } else if ($game_id == 8) {  // mta
            $cena_slota = explode('|', '61din|3.7kn|0.9km|30mkd|0.50eur');
        } else if ($game_id == 9) {  // ark
            $cena_slota = explode('|', '61din|3.7kn|0.9km|30mkd|0.50eur');
        }

    } else if ($loc == 'lite1' || $loc == 'lite2' || $loc == 'lite3') {
        $SQLSEC = $rootsec->prepare("SELECT * FROM `gp_cene` WHERE `game_id` = ?");
        $SQLSEC->Execute(array($game_id));
        $slot_cena = $SQLSEC->fetch(PDO::FETCH_ASSOC);
        $cena_slota = explode('|', $slot_cena['cena_slota']);
    } else {
        // ako je lokacija skroz nepoznata
        return 0;
    }

    // ako i dalje nemamo cl_id, fallback na "other"
    $country = $cl_id ? my_contry($cl_id) : 'other';

    if ($country == "RS") {
        $cena = $cena_slota[0];
    } else if ($country == "HR") {
        $cena = $cena_slota[1];
    } else if ($country == "BA") {
        $cena = $cena_slota[2];
    } else if ($country == "MK") {
        $cena = $cena_slota[3];
    } else if ($country == "ME") {
        $cena = $cena_slota[4];
    } else { // other
        $cena = $cena_slota[0];
    }

    $cena = floatval($cena);
    $slot = floatval($slot);

    $cenaslota = round($cena * $slot, 2);
    $cenaslota = number_format($cenaslota, 2);

    return $cenaslota;
}

function money_val_code($novac, $drzava) {
	if($drzava == "RS"){
		$novac = $novac*120;	
		$novacc = number_format(floatval($novac), 2);
		return $novacc;	
	} else if($drzava == "HR"){
		$novac = $novac*6.5;	
		$novacc = number_format(floatval($novac), 2);
		return $novacc;		
	} else if($drzava == "BA"){
		$novac = $novac*1.7;		
		$novacc = number_format(floatval($novac), 2);
		return $novacc;		
	} else if($drzava == "MK"){
		$novac = $novac*5.36;	
		$novacc = number_format(floatval($novac), 2);
		return $novacc;		
	} else if($drzava == "ME" || $drzava == "other"){	
		$novacc = number_format(floatval($novac), 2);
		return $novacc;		
	}

	return false;
}

function money_smb($mn_smb) {

	$s_zamene = array (
        'EUR'     	=> '&euro;',
    );
        
    $mn_smb = str_replace(array_keys($s_zamene), array_values($s_zamene), $mn_smb);

	return $mn_smb;
}

?>
